## SUPPORTED SYSTEMS 

(as of 2020/09/30)

In principle you can compile the game with minimal input and output for any recent or old/ancient architecture for which there is an ANSI C capable compiler.
For most vintage systems, you can build a version of the game with some graphics, sounds and real time input.


### 8-BIT targets

For most systems, more than one version is built, in order to support different hardware configurations and expansions 
(e.g., memory expansions, second CPU, 80-col display card, etc.).

- `abc80`: Luxor ABC 80
- `abc800`: Luxor ABC 800
- `ace`: Jupiter Ace
- `alphatro`: Alphatronic
- `altair8800`: MITS Altair 8800
- `apple2`: Apple //
- `apple2enh`: Enhanced Apple //e
- `aquarius`: Mattel Aquarius 
- `atari5200`: Atari 5200
- `atari`: Atari 400/800/600XL/800XL/1200XL/65XE/130XE
- `atari_jaguar`: Atari Jaguar
- `atari_lynx`: Atari Lynx
- `attache`: Otrona Attache
- `aussie`: Aussie Byte
- `bbc`: BBC Micro
- `bbcmaster`: BBC Master
- `bic`: BIC/A5105
- `bit90`: Bit Corporation BIT 90
- `c128_8502`: Commodore 128 [8502 CPU]
- `c128_z80`: Commodore 128 [Z80 CPU]
- `c16`: Commodore 264 series (16/116/+4)
- `c64`: Commodore 64
- `c7420`: Philips VideoPac C7420 module (z88dk lib incomplete, work in progress)
- `cbm510`: Commodore CBM 510
- `cbm610`: Commodore CBM 610
- `camputers_lynx`: Camputers Lynx 48k/96k/128k
- `cidelsa_altair`: Cidelsa Altair arcade board
- `cidelsa_destroyer`: Cidelsa Destroyer arcade board
- `cidelsa_draco`: Cidelsa Draco arcade board
- `coco`: Color Computer
- `coleco`: Colecovision
- `coleco_adam`: Colecovision Adam
- `comx`: COMX-35
- `cpc`: Amstrad CPC
- `cpm_8080`: CP/M Intel 8080
- `cpm_z80`: CP/M Z80 with adm3a/vt52/vt100 terminals
- `creativision`: VTech Creativision
- `dai`: DAI
- `dmv`: Decision Mate V
- `dragon`: Dragon 32/64
- `eg2k`: EACA EG2000 Color Genie
- `einstein`: Tatung Einstein
- `enterprise`: Enterprise 64/128
- `excalibur64`: Excalibur64
- `fp1100`: Casio FP-1100
- `g800`: Sharp PC-G800
- `gal`: Galaksija
- `gal_plus`: Galaksija Plus
- `gamate`: Gamate
- `gb`: Game Boy
- `gx4000`: Amstrad GX-4000
- `hemc`: Huebler/Evert-MC
- `hgmc`: Huebler-Grafik-MC
- `homelab`: Homelab 4
- `homelab2`: Homelab 2
- `kaypro`: Kaypro 2X
- `kramermc`: Kramer-MCs
- `kc`: Robotron KC-85/2/3/4
- `lambda`: Lambda 8300
- `laser500`: Laser 500
- `m100`: TRS-80 M100 (z88dk lib incomplete, work in progress)
- `m5`: Sord M5
- `mega65`: Mega 65 / Commodore 65
- `mc1000`: CCE MC-1000
- `microboard`: Microboard Computer Development Board
- `microbee`: Microobee
- `mikro80`: Mikro 80
- `mo5`: Thomson Mo5 / Thomson Mo6 / Olivetti Prodest PC 128
- `msx`: MSX
- `mtx`: Memotech MTX 512
- `mtx500`: Memotech MTX 500
- `multi8`: Mitsubishi Multi 8
- `myvision`: Nichibutsu My Vision
- `mz`: Sharp MZ 80/700
- `mz2500`: Sharp MZ 2500
- `nascom`: Nascom
- `nc100`: Amstrad NC-100/150
- `nc200`: Amstrad NC-200
- `nes`: Nintendo Enterteinment System
- `newbrain`: Grundy Newbrain
- `ondra`: Tesla Ondra Vili
- `oric`: Tangerine Oric 1/Atmos
- `osborne1`: Osborne 1
- `osca`: OSCA v6z80p
- `osic1p`: Ohio Scientific Challenger 1P
- `oz`: Sharp OZ-700
- `p2000`: Philips P2000
- `pacman`: Pacman (work in progress)
- `pasaopia7`: Toshiba Pasopia 7
- `pc6001`: NEC PC 6001
- `pc88`: NEC PC 8801
- `pce`: PCEngine
- `pecom`: Pecom 32/64
- `pencil2`: Hanimex Pencil II
- `pet`: Commodore Pet
- `pmd85`: PMD85
- `pps`: Peters Plus Sprinter
- `primo`: Primo
- `pv1000`: Casio PV1000
- `pv2000`: Casio PV2000
- `px4`: Epson PX-4/HC-40
- `px8`: Epson PX-8/HC-80
- `qc10`: Epson QC-10/QX-10
- `rex`: Xircom Rex 6000 (no available emulator, work in progress)
- `rc700`: Regnecentralen RC700
- `rx78`: Bandai RX-78
- `samcoupe`: Sam Coupe
- `sc3000`: Sega SC 3000
- `sg1000`: Sega SG 1000
- `smc777`: Sony SMC-70 / SMC-777
- `sms`: Sega Master System
- `sos`: S-OS 
- `spc1000`: Samsung SPC 1000
- `special`: Specialist
- `spectrum`: Sinclair Spectrum 16k/48k/128k
- `srr`: Exidy Sorcerer
- `super80`: Super 80/80d/80e/80m
- `super80r`: Super 80r/Super80v
- `supervision`: Watara Supervision
- `sv8000`: Bandai Supervision 8000
- `svi`: Spectravideo 318/328
- `telestrat`: Oric Telestrat
- `tmc600`: Telmac TMC-600
- `ti82`: Texas TI 82
- `ti83`: Texas TI 83
- `ti8x`: Texas TI 83 Plus
- `ti85`: Texas TI 85
- `ti86`: Texas TI 86
- `tiki100`: TIKI 100
- `to7`: Thomson To7 / To7/70 / To8 / To8d / To8+ / To9 / To9+
- `trs80`: TRS-80 Model I/III/IV
- `ts2068`: Timex TS 2068
- `tvc`: Videoton TV Computer
- `vector06c`: Вектор-06Ц - Vector06c
- `vg5k`: VG-5000
- `vic20`: Commodore Vic 20
- `vz200`: VTech VZ200
- `x07`: Casio X-07 (z88dk lib incomplete, work in progress)
- `x1`: Sharp X1
- `z1013`: Robotron Z1013
- `z80tvgame`: ZX80 TV Game
- `z88`: Cambridge Z88
- `z9001`: Robotron Z9001, Robotron KC 85/1, Robotron KC 87 
- `zx80`: Sinclair ZX80
- `zx81`: Sinclair ZX81
- `zxn` : ZX Spectrum Next

### 16-BIT targets
- `amiga`: Amiga 
- `atari_st`: Atari ST
- `cx16`: Commander X16 (work in progress)
- `olivetti_m20`: Olivetti M20 
- `pc8086`: Intel 8088/8086 PC
- `pdp`: PDP 11 v7 (work in progress)
- `sinclair_ql`: Sinclair QL
- `ti99`: Texas Instruments TI99/4A 



### 32-BIT targets
- `linux386`:  ELF linux for Intel 386
- `linux68k`:  ELF linux for Motorola 68020
- `linuxppc`:  ELF linux for PPC
- `linuxmips`: ELF linux for little endian MIPS32r2 (work in progress)


### Modern 32/64-BIT PC targets

There are a plain stdlib (turn based) and an ncurses (action) version that can be compiled for multiple platforms for which an ANSI C compiler and ncurses are available, including Windows and Linux.
For example:
- Cygwin/Windows or Linux (gcc + ncurses, e.g., cygwin/Windows or Linux) 
- Windows 32/64 bit console (mingw-gcc + ncurses, e.g., x86_64-w64-mingw32-gcc)
